<?php

namespace App\Traits;

use Illuminate\Support\Facades\Schema;

trait HelperModelTrait
{
    public function getValOfKey($row, $col)
    {
        $key = explode('_', $col);
        if (count($key) < 2) {
            return '';
        }
        if (!$row->{$key[0]}) {
            return '';
        } elseif (method_exists($row->{$key[0]}, $key[1])) {
            return $row->{$key[0]}->{$key[1]}();
        }
        $str = $row->{$key[0]}->{$key[1]}->{app()->getLocale()} ?? $row->{$key[0]}->{$key[1]} ?? $row->$col ?? '';
        return is_string($str) ? $str : '';
    }

    public function getSearchable()
    {
        return $this->searchable;
    }


    public function model_search($model, $rows, $searchable = null)
    {
        foreach (request()->query() as $key => $value) {
            if (in_array($key, $searchable ?? $model->getFillable())) {
                $rows = $rows->when(request()->has($key), function ($query) use ($key, $value) {
                    if ($value == 0) {
                        return $query->where(function ($query) use ($key, $value) {
                            return $query->whereNull($key)->orWhere($key, $value);
                        });
                    } else {
                        return $query->where($key, $value);
                    }
                });
            }
        }
        if ($word = request('keyword')) {
            if (method_exists($model, 'getSearchable') && $model->getSearchable()) {
                $keys = $model->getSearchable();
                $endcoded_word = str_replace('"', "", json_encode($word));
                $endcoded_word = addslashes($endcoded_word);
                $rows = $rows->where('id', $word);
                foreach ($keys as $index => $key) {
                    $rows = $rows->orWhere(function ($query) use ($key, $word, $endcoded_word) {
                        return $query->where($key, 'like', '%' . $word . '%')->orWhere($key, 'like', '%' . $endcoded_word . '%');
                    });
                }
            } else {
                $keys = $model->getFillable();
                $endcoded_word = str_replace('"', "", json_encode($word));
                $endcoded_word = addslashes($endcoded_word);
                $rows = $rows->where('id', $word);
                foreach ($keys as $index => $key) {
                    if (Schema::hasColumn($model->getTable(), $key)) {
                        $rows = $rows->orWhere(function ($query) use ($key, $word, $endcoded_word) {
                            return $query->where($key, 'like', '%' . $word . '%')->orWhere($key, 'like', '%' . $endcoded_word . '%');
                        });
                    }
                }
            }
        }
        return ['model' => $model, 'rows' => $rows];
    }
}
