<?php

namespace App\Support\Api;

use Modules\Common\Resources\PaginateResource;

trait ApiData
{
    protected function apiData($data): void
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                $pagination = $this->pagenation($value);
                if ($pagination) {
                    $this->pagination = $pagination ?? null;
                    try {
                        $this->data[$key] = $value->toArray()['data'];
                    } catch (\Throwable $th) {
                        $this->data[$key] = $value;
                    }
                }else{
                    $this->data[$key] = $value;
                }
            }
        }else{
            $pagination = $this->pagenation($data);
            if($pagination){
                $this->data = $data ;
                $this->pagination = $pagination ?? null;
            }else{
                $this->data = $data ;
            }

        }
    }

    public function pagenation($model)
    {
        if (is_object($model)) {
            try {
               $model->total();
               return PaginateResource::make($model);
            } catch (\Throwable $e) {

            }
        }
        return null;
    }
}
