<?php

namespace App\Providers;

use App\Exceptions\CustomException;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\ServiceProvider;
use Modules\User\Models\PersonalAccessToken;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Laravel\Sanctum\Sanctum;
use Illuminate\Pagination\Paginator;
use Modules\Playground\Models\Playground;
use Modules\Playground\Observers\PlaygroundObserver;
use Modules\User\Models\User;
use Modules\Match\Models\Matche;
use Modules\Match\Observers\MatchObserver;
use Illuminate\Database\Eloquent\Relations\Relation;
use Modules\Reviews\Models\Review;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(ExceptionHandler::class, CustomException::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (request()->hasHeader('authorization')) {
            Broadcast::routes(['prefix' => 'api', 'middleware' => ['auth:api']]);
        }
        Sanctum::usePersonalAccessTokenModel(PersonalAccessToken::class);
        //        Model::preventLazyLoading(!$this->app->isProduction());
        Paginator::useBootstrap();
        //        if(!env('APP_HTTP')){
        //            \Illuminate\Support\Facades\URL::forceScheme('https');
        //        }

       
        Playground::observe(PlaygroundObserver::class);
        Matche::observe(MatchObserver::class);
        Review::observe(\Modules\Reviews\Observers\ReviewObserver::class);

        Relation::morphMap([
            'playground' => Playground::class,
            'user' => User::class,
            'match' => Matche::class,
            'review' => Review::class,
        ]);
    }
}
