<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class PostMatchReviewNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $data;

    public function __construct(protected $match)
    {
        $this->data['title'] = 'Rate The Match';
        $this->data['message'] = 'How was your match in the playground ' . @$match->playground?->name . ' ? Rate your experience now.';
        $this->data['match_id'] = $match->id;
        $this->data['type'] = 'post_match_review';
    }

    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }

    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle($this->data['title'])
            ->withBody($this->data['message'])
            ->sendMessage('tokens');
    }
}
