<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Playground\Models\Playground;

class NewNearbyPlaygroundNotification extends Notification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data;

    public function __construct(protected $playground)
    {
        $this->data['title'] = __('New Playground Nearby');
        $this->data['message'] = __('A new playground :name is now available near you!', ['name' => $playground->Name]);
        $this->data['playground_id'] = $playground->id;
        $this->data['type'] = 'new_playground_nearby';
    }

    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }

    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle(@$this->data['title'])
            ->withBody(@$this->data['message'])
            ->sendMessage('tokens');
    }
}
