<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Match\Models\Matche;

class NewNearbyMatchNotification extends Notification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data;

    public function __construct(protected $match)
    {
        $playgroundName = $match->playground->Name ?? 'Unknown Playground';

        $this->data['title'] = __('New Match Nearby');
        $this->data['message'] = __('A new match is available at :playground on :date!', [
            'playground' => $playgroundName,
            'date' => $match->date
        ]);
        $this->data['match_id'] = $match->id;
        $this->data['type'] = 'new_match_nearby';
    }

    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }

    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle(@$this->data['title'])
            ->withBody(@$this->data['message'])
            ->sendMessage('tokens');
    }
}
