<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Modules\Reviews\Models\Review;

class NewCommentNotification extends Notification {

    protected $review;

    public function __construct(Review $review)
    {
        $this->review = $review;
    }

    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }

    public function toArray($notifiable)
    {
        $user = $this->review->user;
        $userName = $user ? ($user->FirstName . ' ' . $user->LastName) : __('Unknown User');
        $userImage = $user ? $user->image : '';

        return [
            'type' => 'new_comment',
            'match_id' => $this->review->reviewable_id,
            'comment_id' => $this->review->id,
            'user_name' => $userName,
            'user_image' => $userImage,
            'comment' => $this->review->comment,
            'created_at' => $this->review->created_at->toIso8601String(),
        ];
    }

    public function toFcm($notifiable)
    {

        $data = $this->toArray($notifiable);


        $userName = $data['user_name'];

        return FCMAction::new($notifiable)
            ->withData($data)
            ->withTitle(__('New Comment'))
            ->withBody("{$userName}: {$this->review->comment}")
            ->sendMessage('tokens');
    }
}
