<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class MatchesMissingPlayersNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $data;

    public function __construct(protected $match)
    {
        $this->data['title'] = 'The Match Need Players';
        $this->data['message'] = 'There is a match in the playground ' . @$match->playground?->name . ' need players. Join now!';
        $this->data['match_id'] = $match->id;
        $this->data['type'] = 'matches_missing_players';
    }

    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }

    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle($this->data['title'])
            ->withBody($this->data['message'])
            ->sendMessage('tokens');
    }
}
