<?php

namespace App\Notifications\Couching;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class AcceptedNotifications extends Notification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    protected $data;
    public function __construct()
    {
        $this->data['title'] = 'لقد تم الموافقه علي طلبك';
        $this->data['message'] = 'لقد تم الموافقه علي طلبك';
        $this->data['type'] = 'couching_accepted';
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [ 'database', FcmChannel::class];
    }



    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle(@$this->data['title'])
            ->withBody(@$this->data['message'])
            ->sendMessage('tokens');
    }
}
