<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class AdminNotifications extends Notification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    protected $data;
    public function __construct(protected  $title = '', protected  $message = '', protected $additionalData = [])
    {
        $this->data['title'] = @$title;
        $this->data['message'] = @$message;
        $this->data['type'] = 'admin_notification';
        if (!empty($additionalData)) {
            $this->data = array_merge($this->data, $additionalData);
        }
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }



    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle(@$this->data['title'])
            ->withBody(@$this->data['message'])
            ->sendMessage('tokens');
    }
}
