<?php

namespace App\Http\Requests\Admin\Matches;

use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class ApiStore extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    protected function passedValidation()
    {
        $this->merge([
            'end_time' => Carbon::parse($this->end_time)->format('H:i:s'),
            'start_time' => Carbon::parse($this->start_time)->format('H:i:s'),
        ]);
    }

    public function rules(): array
    {
        return [
            'playground_id' => 'required|exists:playgrounds,id,deleted_at,NULL',
            'supervisor_id' => 'required|exists:users,id,deleted_at,NULL',
            'subscribers_qty' => 'required|integer|numeric|min:0|max:30',
            'date' => 'required|after:yesterday',
            'start_time' => 'required|after:'.now()->format('Y-m-d H:i:s'),
            'end_time' => 'required|after:start_time',
            'durations' => 'required|numeric|min:10',
            'durations_text' => 'required|string|max:250',
            'details' => 'required|string',
            'amount' => 'required|numeric|min:0',
            'type' => 'required|string'
        ];
    }

    protected function prepareForValidation()
    {
        if($this->start_time && $this->durations){
            $this->merge([
                'end_time' => Carbon::parse($this->date.' '.$this->start_time)->addMinutes((int) $this->durations)->format('Y-m-d H:i:s'),
                'start_time' => Carbon::parse($this->date.' '.$this->start_time)->format('Y-m-d H:i:s'),
            ]);
        }
        $this->merge([
            'date' => Carbon::parse($this->date)->format('Y-m-d'),
            'revision' => false,
            'supervisor_id' => auth('api')->id(),
        ]);
    }
}
