<?php

namespace App\Http\Middleware\Api;

use Carbon\Carbon;
use Closure;
use Illuminate\Support\Facades\App;

class ApiLang
{
    public function handle($request, Closure $next)
    {
        $languages = config('app.locales');
        if ($request->header('lang') != null && in_array($request->header('lang'), array_keys($languages))) {
            $lang = $request->header('lang');
        } else {
            $lang = env('APP_LOCALE', 'en');
        }
        App::setLocale($lang);
        Carbon::setLocale($lang);
        return $next($request);
    }
}
