<?php

namespace App\Helpers;

use MshMsh\Helpers\ApiResponder;
use MshMsh\Helpers\Response\ResponseFactory;

class ApiResponse extends ApiResponder
{
    static function get($message = '', $data = null, $status = true, $status_code = 200)
    {
        // معالجة خاصة لأخطاء الـ Validation 422
        if ($status_code == 422) {
            if ($data && is_array($data) && count($data) > 0) {
                $message = $data[array_key_first($data)];
                $data = null;
            }
        }

        $response = ResponseFactory::get($status_code, $message, $data);

        if ($status_code >= 400 && isset($response['data'])) {
            $response['error'] = $response['data'];
            unset($response['data']);
        }

        return response()->json($response, $status_code);
    }

    public static function make($data = null, $message = '', $code = 200)
    {
        // لازم نبعت 4 بارامترات عشان توافق دالة get
        // البارامتر الثالث (true) ده مجرد حشو عشان نحافظ على الترتيب وميزعلش الـ PHP
        return self::get(
            $message,
            $data,
            true, // قيمة وهمية للـ status مش هتأثر في حاجة لأننا تجاهلناها جوه
            $code
        );
    }

    public static function successCode()
    {
        return [
            200,
            201,
            202,
            203,
            204,
            302,
        ];
    }

    public static function loaded($data = null, $code = 200, $message = "Loaded Successfully")
    {
        return self::make($data, __($message), $code);
    }

    public static function created($data = null, $message = null, $code = 200)
    {
        return self::make($data, $message ?? __('Created Successfully'), $code);
    }

    public static function failed($message, $code = 400)
    {
        return self::make(null, $message, $code);
    }

    public static function updated($data = null, $code = 200)
    {
        return self::make($data, __('Updated Successfully'), $code);
    }

    public static function deleted($code = 200, $message = 'Deleted Successfully')
    {
        return self::make(null, __($message), $code);
    }

    public static function notFound($message = null)
    {
        return self::make(null, $message ?? __('Not Found'), 404);
    }

    public static function alreadyExists($record)
    {
        return self::make(null, __('Already Exists', ['attr' => $record]), 404);
    }

    public static function unKnowError()
    {
        return self::make(null, __('Something wrong. Try again later'), 500);
    }
}
