<?php

namespace App\Exceptions;

use Exception;
use BadMethodCallException;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Http;
use Illuminate\Validation\ValidationException;
use MshMsh\Helpers\ApiResponder;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

use App\Helpers\ApiResponse;

class CustomException extends ExceptionHandler
{
    public function render($request, Throwable $exception)
    {
        if ($request->wantsJson()) {
            if ($exception instanceof ValidationException) {
                $errors = $exception->errors();
                $myerrors = [];
                foreach ($errors as $key => $error) {
                    $myerrors[$key] = $error[0];
                }
                return ApiResponse::make($myerrors, __('Validation Error'), 400);
            } elseif ($exception instanceof NotFoundHttpException) {
                return ApiResponder::get('This url not found please check it again', null, false);
            } elseif ($exception instanceof MethodNotAllowedHttpException) {
                return ApiResponder::get($exception->getMessage(), null, false);
            } elseif ($exception instanceof BadMethodCallException) {
                // return api_response('error', $exception->getMessage(), null, 500);
            } elseif ($exception instanceof AuthenticationException) {
                return ApiResponse::failed(__("Invalid credentails"), 400);
            } elseif ($exception instanceof ModelNotFoundException) {
                return ApiResponder::get(__('there is no data'), null, false, 404);
            }
        }
        return parent::render($request, $exception);
    }

    public function report(Throwable $e)
    {
        if ($this->shouldReport($e)) {
            if (config("discord.webhook")) {
                if (env('APP_DEVELOP') == true) {
                    Http::post(
                        config('discord.webhook'),
                        [
                            "content" => 'remontada:' . $e->getMessage() . "\n" . $e->getFile() . "\n" . $e->getLine()
                        ]
                    );
                }
            }
        }

        return parent::report($e); // TODO: Change the autogenerated stub
    }
}
