<?php

use Illuminate\Support\Facades\Http;
use Modules\Pages\Models\Page;


function pages()
{
    return Page::get();
}


#convert arabic number to english format - user model
if (!function_exists('convert_to_english')) {
    function convert_to_english($string)
    {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];

        $num = range(0, 9);
        $convertedPersianNums = str_replace($persian, $num, $string);
        $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);

        return $englishNumbersOnly;
    }
}
#get value from settings DB
function settings($key)
{
    $setting = \Modules\Common\Models\Setting::firstOrCreate(['key' => $key,'type'=>'settings']);
    return $setting['value'];
}

function send_sms($mobileNumber, $messageContent)
{
    $token = "ZvPWfiYgU7lTbRk0Fe3J";
    $curl = curl_init();
    if (str_contains(substr($mobileNumber, 0, 2), '05')) {
        $mobileNumber = '966' . substr($mobileNumber, 1);
    }

    $fields = [
        'src' => 'DA SALE',
        'dests' => [
            $mobileNumber
        ],
        'body' => $messageContent
    ];

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.oursms.com/msgs/sms',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($fields),
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json',
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    if (request('test')) {
        dd(json_decode($response));
    }
    return $response;
}

