<?php
$mail_social_icons = [
    'twitter' => 'https://imageupload.io/ib/eiyT5KISfmrVF5l_1698059528.png',
    'instagram' => 'https://imageupload.io/ib/GqfSi8sIUs3Ct3f_1698059551.png',
    'whatsapp' => 'https://imageupload.io/ib/aW0uAMcXoT4SJ9z_1698059569.png',
    'facebook' => 'https://imageupload.io/ib/fQ92ZA2Vug9z288_1698059586.png',
];
$color = env('MAIL_COLOR') ?? '#E52521';
?>
<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
    <title>{{ $msg->title ?? (app_setting('title') ?? env('APP_NAME')) }}</title>
    <meta name="description" content="{{ $msg->title ?? (app_setting('title') ?? env('APP_NAME')) }}." />
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Noto+Sans+Arabic&display=swap');

        *,
        tr,
        td,
        h1,
        a,
        p,
        th {
            font-family: 'Noto Sans Arabic', sans-serif !important;
        }

        a:hover {
            text-decoration: underline !important;
        }
    </style>
</head>

<body marginheight="0" topmargin="0" marginwidth="0" style="margin: 0px; background-color: #f2f3f8" leftmargin="0">
    <!-- 100% body table -->
    <table cellspacing="0" border="0" cellpadding="0" width="100%" bgcolor="#f2f3f8">
        <tr>
            <td>
                <table style="background-color: #f2f3f8; max-width: 670px; margin: 0 auto" width="100%" border="0"
                    align="center" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="height: 80px">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="height: 20px">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>
                            <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0"
                                style="
                    max-width: 670px;
                    background: #fff;
                    border-radius: 3px;
                    text-align: center;
                    border-radius: 30px;
                    overflow: hidden;
                    -webkit-box-shadow: 0 6px 18px 0 rgba(0, 0, 0, 0.06);
                    -moz-box-shadow: 0 6px 18px 0 rgba(0, 0, 0, 0.06);
                    box-shadow: 0 6px 18px 0 rgba(0, 0, 0, 0.06);
                  ">
                                <tr>
                                    <td
                                        style="padding-top: 30px; background:linear-gradient(180deg ,{{ $color }} 0%,{{ $color }} 80%, #fff 80%, #fff 100%); height: 120px">
                                        <div
                                            style="background-color:#eee!important;width:120px;height:120px;padding:20px;border-radius:50%;border: 10px solid #fff;margin:0 auto;display: flex;align-items: center;justify-content: center;box-shadow: 0px 0px 20px 0px #000;">
                                            <a style="display: table;margin:auto" href="{{ url('/') }}"
                                                title="logo" target="_blank">
                                                <img width="60" src="{{ app_setting('logo') }}" title="logo"
                                                    alt="logo" style="color-scheme: light dark;" />
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 0 35px; padding-top: 2%;">
                                        <h1
                                            style="
                          color: #1e1e2d;
                          font-weight: 700;
                          margin: 0;
                          font-size: 32px;
                          margin-bottom: 20px;
                        ">
                                            {{ $msg->title }}
                                        </h1>
                                        <p
                                            style="
                          font-size: 20px;
                          color: #455056;
                          margin: 8px 0 0;
                          line-height: 24px;
                        ">
                                            {!! $msg->content !!}
                                            @if (isset($msg->code))
                                                <span style="font-weight: 800;">{{ $msg->code }}</span>
                                            @endif
                                        </p>
                                        @if (isset($msg->button_link))
                                            <a
                                                style="
                          background: {{ $color }};
                          text-decoration: none !important;
                          display: inline-block;
                          font-weight: 500;
                          margin-top: 24px;
                          color: #fff;
                          text-transform: uppercase;
                          font-size: 14px;
                          padding: 20px 24px;
                          display: inline-block;
                          border-radius: 50px;
                        ">{{ $msg->button_txt }}</a>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height: 50px">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td style="display: flex;">
                                        <div style="width: 100%;"><a style="text-decoration: none; color: #1e1e2d;"
                                                href="mailto:{{ app_setting('email') }}">Mail:
                                                {{ app_setting('email') }}</a></div>
                                        <div class="black-border" style="width: 1px; background-color: #1e1e2d;"></div>
                                        <div style="width: 100%;"><a style="text-decoration: none; color: #1e1e2d;"
                                                href="tel:{{ app_setting('mobile') }}">Call Us:
                                                {{ app_setting('mobile') }}</a></div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height: 30px">&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr>
                        <td style="height: 20px">&nbsp;</td>
                    </tr>

                    <tr>
                        <td>
                            <table style="margin: 0 auto;">
                                <tr>
                                    @foreach (socials() as $row)
                                        <td style="cursor: pointer;">
                                            <a href="{{ $row->value->all ?? $row->value }}" target="_blank"
                                                style="width: 100%; height: 100%;"><img
                                                    src="{{ $mail_social_icons[$row->key] ?? '' }}" alt=""></a>
                                        </td>
                                    @endforeach
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr>
                        <td style="height: 20px">&nbsp;</td>
                    </tr>


                    <tr>
                        <td style="text-align: center">
                            <p
                                style="
                    font-size: 14px;
                    color: rgba(69, 80, 86, 0.7411764705882353);
                    line-height: 18px;
                    margin: 0 0 0;
                  ">
                                &copy; <strong>{{ url('/') }}</strong>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="height: 80px">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <!--/100% body table-->
</body>

</html>
