<?php

namespace Modules\User\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SignUpPlayGroundMaster extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'FirstName' => 'required|min:1|max:60',
            'LastName' => 'required|min:1|max:60',
            'phone' => 'required|unique:users,phone,NULL,id,deleted_at,NULL',
            'email' => 'required|unique:users,email,NULL,id,deleted_at,NULL|email',
            'Nationality' => 'nullable|string',
            'gender' => 'nullable|in:male,female',
            'NickName' => 'nullable|min:1|max:60|unique:users,NickName',
            'self_Ranking' => 'nullable|numeric',
            'position_id' => 'nullable|exists:locations,id,deleted_at,NULL',
            'Date_of_Birth' => 'nullable|date|between:1960-01-01,2020-12-29',
            'address' => 'required',
            'longitude' => 'required|numeric',
            'latitude' => 'required|numeric',
            'password' => 'required|min:6',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:10240',
            'notification_settings' => 'nullable|array',

            // Playground Validation
            'playground_name' => 'required|string|max:255|unique:playgrounds,Name',
            'playground_address' => 'required|string|max:255',
            'playground_latitude' => 'required|numeric|min:-90|max:90',
            'playground_longitude' => 'required|numeric|min:-180|max:180',
        ];
    }
}
