<?php

namespace Modules\User\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Modules\User\Models\Token;
use Modules\User\Models\User;
use Modules\User\Services\Confirmation;

class PasswordController extends Controller
{

    public function forget(Request $request)
    {
        if ($request->isMethod('GET')) {
            return view('User::password.forget');
        }
        if ($user = User::where('email', $request->email)->first()) {
            Confirmation::sendMail($user);
            return redirect()->route('password.code', Crypt::encrypt($request->email))
                ->with('success', __('Confirmation code sent to your email'));
        }
        return back()->with('error', __('User not found'));
    }

    public function code(Request $request, $token)
    {
        if ($request->isMethod('GET')) {
            return view('User::auth.activate', [
                'email' => Crypt::decrypt($token),
                'action' => route('password.reset', $token)
            ]);
        }
    }

    public function reset(Request $request, $email)
    {
        if ($request->code) {
            $token = implode('', $request->code);
            $token = Token::where('token', $token)->latest()->first();
            if (!$token) {
                return back()->with('error', __('Not valid confirmation code'));
            }
            return view('User::password.reset', ['email' => $email]);
        } elseif ($request->password) {
            $request->validate(['password' => 'required|confirmed']);
            $user = User::where('email', Crypt::decrypt($request->email))->firstOrFail();
            $user->update(['password' => $request->password]);
            auth()->login($user);
            return redirect()->to('/')->with('success', __('Password changed successfully'));
        }
    }
}
