<?php

namespace Modules\Sliders\Models;

use App\Traits\DefaultMediaImage;
use App\Traits\HasActive;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Slider extends Model implements HasMedia
{
    use InteractsWithMedia,
    DefaultMediaImage,HasActive;
    protected $fillable = [
        'title',
        'link',
        'link_type',
        'sort',
        'image',
        'status'
    ];
    protected $hidden = ['created_at', 'updated_at'];

    public function setImageAttribute($image)
    {
        if (is_uploaded_file($image)) {
            $this->clearMediaCollection('image');
            $this->addMediaFromRequest('image')
                ->toMediaCollection('image');
        }
    }

    public function getImageAttribute()
    {
        $this::$defaultImage = '/placeholders/item.png';
        return $this->getFirstOrDefaultMediaUrl('image');
    }
}
