<?php

namespace Modules\Sliders\Controllers;

use App\Enum\InternalLink;
use App\Helpers\ApiResponder;
use App\Helpers\ApiResponse;
use App\Http\Requests\Admin\Sliders\Store;
use Illuminate\Http\Request;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Sliders\Models\Slider;

class AdminController extends HelperController
{
    public function __construct()
    {
        $this->model = new Slider();
        $this->rows = $this->model->orderBy('sort');
        $this->title = "Sliders";
        $this->name =  'sliders';
        $this->list = [
            'image' => __('image'),
            'title' => __('name')
        ];
        $this->formRequest = Store::class;

        $this->switches['status'] = route('admin.sliders.active_status');
        $this->routeSortList = route('admin.sliders.changeSortable');
    }

    public function formBuilder()
    {
        $this->inputs = [
            'title' => ['title' =>  __('title')],
            'image' =>  ['title' => __('image'), 'type' => 'image'],
            'link' => ['title' => __('link'),'empty'=>1],
        ];
    }
    public function active_status(Request $request)
    {
        $slider = Slider::findOrFail($request->id);
        $slider->update(['status' => !$slider->status]);
        return ApiResponse::get( '', ['status' => 1]);
    }
    public function changeSortable(Request $request)
    {
        $data = $request->sort;
        foreach ($data as $d){
            Slider::where('id',$d['id'])->update(['sort' => $d['sort']]);
        }
    }
}
