<?php

namespace Modules\Reviews\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreReviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'user_id' => 'required|exists:users,id',
            'rating' => 'nullable|integer|between:1,10',
            'comment' => 'nullable|string',
            'reviewable_id' => 'required|integer',
            'reviewable_type' => 'required|string',
        ];
    }
}
