<?php

namespace Modules\Playground\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Categories\Models\Category;
use Modules\Categories\Resources\CategoryResource;

class PlaygroundRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [

            'name' => 'required|string|unique:playgrounds,name|max:255',
            'owner' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'telephone' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'grass_type' => 'required|string|max:255',
            'accessibility' => 'required|string|max:255',
            'status' => 'nullable|in:active,inactive,pending',
            'disability_parking' => 'nullable|boolean',
            'disability_activity_areas' => 'nullable|boolean',
            'disability_social_areas' => 'nullable|boolean',
            'About' => 'nullable|string',
            'disability_spectator_areas' => 'nullable|boolean',
            'disability_changing_facilities' => 'nullable|boolean',
            'disability_toilets' => 'nullable|boolean',
            'disability_finding_and_reaching_the_entrance' => 'nullable|boolean',
            'disability_reception_area' => 'nullable|boolean',
            'disability_doorways' => 'nullable|boolean',
            'disability_emergency_exits' => 'nullable|boolean',
            'latitude' => 'required|numeric|min:-90|max:90',
            'longitude' => 'required|numeric|min:-180|max:180',
            'Category_ID' => 'nullable|exists:categories,id',
            'media' => 'nullable|array',
            'media.*' => 'file|mimes:jpeg,png,jpg,gif,svg,mp4,mov,avi,wmv|max:20480',
            'slots' => 'nullable|array',
        ];
    }
}

