<?php

namespace Modules\Playground\Observers;

use Modules\Playground\Models\Playground;
use Illuminate\Support\Facades\Log;
use Modules\Playground\Jobs\ProcessPlaygroundNotifications;

class PlaygroundObserver
{
    /**
     * Handle the Playground "creating" event.
     */
    public function creating(Playground $playground): void {}

    /**
     * Handle the Playground "created" event.
     */
    public function created(Playground $playground): void
    {
        // Check if this is the first playground for this owner
        if (Playground::where('Owner_ID', $playground->Owner_ID)->count() == 1) {
            ProcessPlaygroundNotifications::dispatch($playground);
        }
    }

    /**
     * Handle the Playground "updated" event.
     */
    public function updated(Playground $playground): void {}

    /**
     * Handle the Playground "deleted" event.
     */
    public function deleted(Playground $playground): void
    {
        //
    }

    /**
     * Handle the Playground "restored" event.
     */
    public function restored(Playground $playground): void
    {
        //
    }

    /**
     * Handle the Playground "force deleted" event.
     */
    public function forceDeleted(Playground $playground): void
    {
        //
    }
}
