<?php

namespace Modules\Payment\Services;

use Modules\Payment\Gateways\StripeGateway;
use Exception;

class PaymentGatewayManager
{
    public function gateway($type = 'stripe')
    {
        switch ($type) {
            case 'stripe':
                return new StripeGateway();
                default:
                throw new Exception("Payment gateway type [$type] is not supported.");
        }
    }
}
