<?php

use Illuminate\Support\Facades\Route;
use Modules\Payment\Controllers\StripeWebhookController;
use Modules\Payment\Controllers\PaymentController;

// Webhook Route (No Auth)
Route::post('/stripe/webhook', [StripeWebhookController::class, 'handleWebhook']);

// Public Callback Routes (Stripe redirects here)
Route::get('/payment/success', [PaymentController::class, 'success'])->name('payment.success');
Route::get('/payment/cancel', [PaymentController::class, 'cancel'])->name('payment.cancel');

// Protected Routes
Route::middleware('auth:api')->group(function () {
    Route::post('/payment/charge', [PaymentController::class, 'chargeWallet']);
});
