<?php

namespace Modules\Pages\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use Modules\Pages\Models\Page;
use Modules\Pages\Resources\PageResource;
use MshMsh\Helpers\ApiResponder;

class ApiController extends Controller
{

    public function about()
    {
        $page = Page::whereType('about')->first();
        return ApiResponse::loaded([
            'page' => PageResource::make($page)
        ]);
    }


    public function policy()
    {
        $page = Page::whereType('policy')->first();
        return ApiResponse::loaded([
            'page' => PageResource::make($page)
        ]);
    }

    public function terms()
    {
        $page = Page::whereType('terms')->first();
        return ApiResponse::loaded([
            'page' => PageResource::make($page)
        ]);
    }
}
