@extends('Common::admin.layout.page')

@section('page')
<div class="row">
    <div class="col-sm-12">
        <!-- general form elements -->
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">
                    {{ __('show details') }}
                </h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-stripped">
                    <tbody>
                        <tr>
                            <th>{{ __('playground') }}</th>
                            <td>{{ $match->playground?->Name }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('date') }}</th>
                            <td>{{ $match->date }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('start time') }}</th>
                            <td>{{ $match->start_time }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('end time') }}</th>
                            <td>{{ $match->end_time }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('subscribers') }}</th>
                            <td>{{ $match->players_per_side * 2 }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('price') }}</th>
                            <td>{{ $match->price }}</td>
                        </tr>
                   
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-12">
        <!-- general form elements -->
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">
                    {{ __('subscribers') }}
                </h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-stripped">
                    <tbody>
                        <tr>
                            <th>{{ __('name') }}</th>
                            <th>{{ __('mobile') }}</th>
                            <th>{{ __('team side') }}</th>
                            <th>{{ __('created at') }}</th>
                        </tr>
                        @if($match->teamPlayers->count() > 0)
                        @foreach($match->teamPlayers as $player)
                        <tr>
                            <td>
                                {{$player->name}}
                            </td>
                            <td>
                                {{$player->full_phone}}
                            </td>
                            <td>
                                {{$player->pivot->team_side}}
                            </td>
                            <td>
                                {{$player->pivot->created_at}}
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="4">{{__('there is no data')}}</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop