@extends('Common::admin.layout.page')
@section('page')
<form action="{{ $action }}" method="post" enctype="multipart/form-data" class="action_form" novalidate>
    @foreach (request()->query() as $key => $val)
    <input type="hidden" name="{{ $key }}" value="{{ $val }}">
    @endforeach
    @if ($method == 'put')
    {{ method_field('put') }}
    @endif
    @csrf
    @if (isset($langInputs) && count($langInputs))
    <div class="col-sm-12">
        <div class="row">

            @include('Common::admin.form.lang_inputs')

            @if (count($inputs ?? []))
            @php $group_title = __('Options') @endphp
            @include('Common::admin.form.inputs')
            @endif

        </div>
    </div>
    @elseif (isset($group_inputs))
    @include('Common::admin.form.groups')
    @else
    @php $title = __($title).' [ '.($method == 'post' ? __('Add') : __('Edit')).' ]'; @endphp
    @include('Common::admin.form.inputs')
    @endif
    <div class="col-sm-12">
        @include('Common::admin.form.includes')
        @include('Common::admin.form.images')
        @include('Common::admin.form.map')
    </div>


    <div class="col-sm-12">
        <div class="card">
            <div class="card-footer">
                <button type="submit" class="btn btn-primary"> <span>{{ __('Save') }}</span>
                    <i class="fas fa-save"></i></button>
            </div>
        </div>
    </div>
</form>
@if (!count(request()->query()) && (!isset($isSetting) || !$isSetting) && !$model->id)
<script>
    $(".select2").val('').trigger('change');
</script>
@endif
<script>
    $('.select2').select2({
        allowClear: true,
        placeholder: function() {
            console.log($(this).data('placeholder'));
            $(this).data('placeholder');
        }
    });

    $(document).ready(function() {
        $('select[name="playground_id"]').on('change', function() {
            var playgroundId = $(this).val();
            var $playersInput = $('input[name="players_per_side"]');
            var $suggestionMsg = $('#slots-suggestion');

            if ($suggestionMsg.length === 0) {
                $playersInput.before('<small id="slots-suggestion" class="text-muted d-block mb-1 font-weight-bold"></small>');
                $suggestionMsg = $('#slots-suggestion');
            }

            $suggestionMsg.text('{{ __("Loading slots...") }}');

            if (playgroundId) {
                $.ajax({
                    url: "{{ route('admin.matches.get_slots') }}",
                    type: "GET",
                    data: {
                        playground_id: playgroundId
                    },
                    success: function(data) {
                        var slots = [];
                        $.each(data, function(key, value) {
                            slots.push(value);
                        });

                        if (slots.length > 0) {
                            $suggestionMsg.html('<span class="text-info"><i class="fas fa-info-circle"></i> {{ __("Available slots for this playground:") }} ' + slots.join(', ') + '</span>');
                        } else {
                            $suggestionMsg.text('');
                        }
                    },
                    error: function() {
                        $suggestionMsg.text('');
                    }
                });
            } else {
                $suggestionMsg.text('');
            }
        });
    });
</script>
@stop