<?php

use Illuminate\Support\Facades\Route;
use Modules\Match\Controllers\ApiController;
Route::middleware('api')->group(function () {
    Route::prefix('matches')->group(function () {
        Route::get('/index', [ApiController::class, 'index']);
        Route::get('/show/{id}', [ApiController::class, 'show']);
        Route::get('/nearest', [ApiController::class, 'nearest']);
        Route::get('/upcommingmatches/{playground_id}', [ApiController::class, 'upcommingmatches']);
    Route::middleware('auth:sanctum')->group(function () {
        Route::post('/create', [ApiController::class, 'store']);
        Route::post('/update/{id}', [ApiController::class, 'update']);
        Route::post('/delete/{id}', [ApiController::class, 'destroy']);
        Route::post('/join', [ApiController::class, 'join']);
    });
});
});