<?php

namespace Modules\Match\Resources;

use Carbon\Carbon;
use App\Enum\MatchType;
use Modules\Teams\Resources\TeamResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Playground\Resources\LocationMapResource;
use Modules\Playground\Resources\PlaygroundResource;
use Modules\User\Resources\UserResource;

class MatcheResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'gender' => $this->gender,
            'price' => $this->price,
            'currency' => $this->currency,
            'status' => $this->status,
            'name' => $this->name,
            'players_per_side' => $this->players_per_side,
            'start_time' => $this->start_time,
            'end_time' => $this->end_time,
            'paid_online' => $this->paid_online,
            'refund' => $this->refund,
            'About' => $this->About,
            'playground' => PlaygroundResource::make($this->whenLoaded('playground')),
            'organizer' => UserResource::make($this->whenLoaded('user')),
            'players' => UserResource::collection($this->whenLoaded('teamPlayers')),
            'players_count' => $this->team_players_count,
            'white_team_players_count' => $this->white_team_players_count,
            'dark_team_players_count' => $this->dark_team_players_count,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'distance' => $this->distance,
        ];
    }
}
