<?php

namespace Modules\Match\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Modules\Match\Models\Matche;
use Modules\User\Models\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\NewNearbyMatchNotification;

class ProcessMatchNotifications implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $tries = 3;
    public $timeout = 120;

    protected $match;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Matche $match)
    {
        $this->match = $match;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $this->match->load('playground');
        $playground = $this->match->playground;

        if (!$playground || !$playground->Latitude || !$playground->Longitude) {
            return;
        }

        //  Notify nearby users (within 10km)
        $radius = 10;
        User::select('users.*')
            ->selectRaw("( 6371 * acos( cos( radians(?) ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians(?) ) + sin( radians(?) ) * sin( radians( latitude ) ) ) ) AS distance", [$playground->Latitude, $playground->Longitude, $playground->Latitude])
            ->having('distance', '<', $radius)
            ->chunk(100, function ($users) {
                Notification::send($users, new NewNearbyMatchNotification($this->match));
            });
    }
}
