<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no"
    />
    <title>Move Up</title>
    <link rel="shortcut icon" type="img/png" href="{{asset('site/images/fav.png')}}" />
    <link rel="stylesheet" href="{{asset('site/css/bootstrap.rtl.min.css')}}" />
    <link rel="stylesheet" href="{{asset('site/css/swiper-bundle.min.css')}}" />
    <link rel="stylesheet" href="{{asset('site/css/sal.css')}}" />
    <link rel="stylesheet" href="{{asset('site/css/line-awesome.css')}}" />
    <link rel="stylesheet" href="{{asset('site/css/main.css')}}" />
</head>

<body data-bs-spy="scroll" data-bs-target="#fixedNavbar">
<!-- Start Header -->
<header id="header">
    <div class="container">
        <div class="header">
            <div href="index.html" class="logo">
                <img src="{{asset('site/images/logo.png')}}" class="img-fluid" />
            </div>

            <div class="overlay"></div>

            <nav class="navbar" id="fixedNavbar">
                <ul class="nav nav-pills">
                    <li class="nav-item">
                        <a class="nav-link" href="#main"> عن c </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="#app"> لمحة عن اتلطبيق </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="#download"> حمل التطبيق </a>
                    </li>

                </ul>

            </nav>

            <button class="menu-btn">
            <span class="hamburger-lines">
              <span class="line line1"></span>
              <span class="line line2"></span>
              <span class="line line3"></span>
            </span>
            </button>
        </div>
    </div>
</header>
<!-- End Header -->

<!-- Start Hero -->
<main id="main">
    <div class="main-sec">
        <div class="container">
            <div class="main">
                <div class="main-text">
                    <h1 class="main-title" data-sal="slide-up">
                        اللعب صار أسهل مع ريمونتادا

                    </h1>
                    <p
                        class="main-desc"
                        data-sal="slide-up"
                        style="--sal-delay: 0.2s"
                    >
                        سواء عندك فريق أو ما عندك، سجل في المباراة اللي تناسبك، وحياك في الملعب تحت إدارة أحد المنظمين في تطبيق ريمونتادا


                    </p>
                    <div
                        class="main-download"
                        data-sal="slide-up"
                        style="--sal-delay: 0.4s"
                    >
                        <h6 class="download-title">
                            قــم بتـحـمـيـل التـطـــــبيق الآن
                        </h6>
                        <div class="download-cont">
                            <a href="https://play.google.com/store/apps/details?id=com.masader.remontada&pcampaignid=web_share" class="download-btn">
                                <img src="{{asset('site/images/download/google.svg')}}" />
                                تحميل تطبيق الأندرويد
                            </a>
                            <a href="https://apps.apple.com/sa/app/remontada-%D8%B1%D9%8A%D9%85%D9%88%D9%86%D8%AA%D8%A7%D8%AF%D8%A7/id6550914902?l=ar" class="download-btn">
                                <img src="{{asset('site/images/download/apple.svg')}}" />
                                تحميل تطبيق الآيفون
                            </a>
                        </div>
                    </div>
                </div>
                <div class="main-img" data-sal="zoom-in" style="--sal-delay: 0.2s">
                    <img src="{{asset('site/images/main/011.png')}}" class="img-fluid" />
                </div>
            </div>
        </div>
    </div>
</main>
<!-- End Hero -->


<!-- Start App -->
<section id="app">
    <div class="app-sec">
        <div class="container">
            <h3 class="sec-title" data-sal="slide-down">لمحة عن التطبيق</h3>
            <div class="app-slider" data-sal="slide-up">
                <div class="swiper">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="app-screen">
                                <div class="app-img">
                                    <img src="{{asset('site/images/app/01.png')}}" class="img-fluid" />
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="app-screen">
                                <div class="app-img">
                                    <img src="{{asset('site/images/app/02.png')}}" class="img-fluid" />
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="app-screen">
                                <div class="app-img">
                                    <img src="{{asset('site/images/app/03.png')}}" class="img-fluid" />
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="app-screen">
                                <div class="app-img">
                                    <img src="{{asset('site/images/app/04.png')}}" class="img-fluid" />
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="app-screen">
                                <div class="app-img">
                                    <img src="{{asset('site/images/app/05.png')}}" class="img-fluid" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="slider-navs">
                    <div class="swiper-button-prev swiper-btn">
                        <i class="las la-angle-right"></i>
                    </div>
                    <div class="swiper-button-next swiper-btn">
                        <i class="las la-angle-left"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End App -->


<!-- Start Download -->
<section id="download">
    <div class="download-sec">
        <img src="{{asset('site/images/download/curve.svg')}}" class="img-fluid curve-bg" />
        <div class="container">
            <div class="download-content">
                <div class="download-text">
                    <h3 class="sec-title" data-sal="slide-down">حمل التطبيق</h3>
                    <p
                        class="download-desc"
                        data-sal="slide-down"
                        style="--sal-delay: 0.2s"
                    >
                        قم بتحميل التطبيق الآن سجل في المباراة اللي تناسبك
                    </p>
                    <div
                        class="download-cont"
                        data-sal="slide-down"
                        style="--sal-delay: 0.4s"
                    >
                        <a href="https://play.google.com/store/apps/details?id=com.masader.remontada&pcampaignid=web_share" class="download-btn">
                            <img src="{{asset('site/images/download/google.svg')}}" />
                            تحميل تطبيق الأندرويد
                        </a>
                        <a href="https://apps.apple.com/sa/app/remontada-%D8%B1%D9%8A%D9%85%D9%88%D9%86%D8%AA%D8%A7%D8%AF%D8%A7/id6550914902?l=ar" class="download-btn">
                            <img src="{{asset('site/images/download/apple.svg')}}" />
                            تحميل تطبيق الآيفون
                        </a>
                    </div>
                </div>
                <div class="download-imgs">
                    <img
                        src="{{asset('site/images/download/01.png')}}"
                        data-sal="flip-right"
                        style="--sal-delay: 0.2s"
                    />
                    <img
                        src="{{asset('site/images/download/02.png')}}"
                        data-sal="zoom-in"
                        style="--sal-delay: 0.4s"
                    />
                    <img
                        src="{{asset('site/images/download/03.png')}}"
                        data-sal="flip-right"
                        style="--sal-delay: 0.6s"
                    />
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Download -->


<!-- Start Footer
<footer>
  <div class="container">
    <div class="footer">
      <div class="footer-logo" data-sal="slide-down">
        <img src="images/logo.png" class="img-fluid" />
      </div>
      <div class="footer-contacts">
        <div
          class="footer-contact"
          data-sal="slide-down"
          style="--sal-delay: 0.2s"
        >
          <h4 class="footer-title">تواصل معنا</h4>
          <a href="tel:+000000000000" class="contact-method">
            +000000000000
          </a>
        </div>
        <div
          class="footer-contact"
          data-sal="slide-down"
          style="--sal-delay: 0.4s"
        >
          <h4 class="footer-title">راسلنا عبر</h4>
          <a href="mailto:info_2023@masti.com" class="contact-method">
            info_2023@masti.com
          </a>
        </div>
      </div>
      <div
        class="footer-socials"
        data-sal="slide-down"
        style="--sal-delay: 0.6s"
      >
        <h4 class="footer-title">يمكنك متابعتنا من خلال حساباتنا</h4>
        <div class="socials">
          <a href="#!" class="social">
            <i class="lab la-twitter"></i>
          </a>
          <a href="#!" class="social">
            <i class="lab la-snapchat"></i>
          </a>
          <a href="#!" class="social">
            <i class="lab la-tiktok"></i>
          </a>

          <a href="#!" class="social">
            <i class="lab la-instagram"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</footer>
 -->
<p class="copyrights">© جميع الحقوق محفوظة - ريمونتادا </p>
<!-- End Footer -->
<script src="{{asset('site/js/jquery.min.js')}}"></script>
<script src="{{asset('site/js/popper.min.js')}}"></script>
<script src="{{asset('site/js/bootstrap.min.js')}}"></script>
<script src="{{asset('site/js/swiper-bundle.min.js')}}"></script>
<script src="{{asset('site/js/sal.js')}}"></script>
<script src="{{asset('site/js/main.js')}}"></script>
</body>
</html>
