@php
$id = 'file_input_' . uniqid();
$isMultiple = isset($input['multiple']) && $input['multiple'];
$image = is_string($value) ? url($value) : "";
@endphp

<div class="form-group" id="{{ $id }}_container">
    <label for="{{ $id }}">{{ $input['title'] }}</label>

    @if ($image && !$isMultiple)
    <div class="mb-2">
        <a href="{{ $image }}" target="_blank" style="font-size:13px">عرض المرفق</a>
        <img src="{{ $image }}" style="max-height: 100px; border-radius: 5px; display: block; margin-top: 5px;">
    </div>
    @endif

    <div class="input-group">
        <div class="mycustom-file">
            <input
                id="{{ $id }}"
                {{ $required }}
                name="{{ $name }}"
                type="file"
                class="mycustom-file-input"
                {{ $isMultiple ? 'multiple' : '' }}>
            <label title="@lang('Choose image')" class="mycustom-file-label" for="{{ $id }}">
                <div class="image">
                    <i class="fas fa-image"></i>
                    <span>@lang('Choose image')</span>
                    @if($image && !$isMultiple)
                    <img onerror="this.style.display='none'" src="{{ $image }}">
                    @endif
                </div>
            </label>
        </div>
    </div>

    {{-- Existing Media --}}
    @if(isset($model) && method_exists($model, 'getMedia'))
    <div class="mt-3 d-flex flex-wrap" style="gap: 10px;">
        @foreach($model->getMedia('*') as $media)
        <div class="existing-media-item" id="media-{{ $media->id }}" style="position: relative; display: inline-block; border: 1px solid #ddd; padding: 5px; border-radius: 5px;">
            <a href="{{ url($media->getUrl()) }}" target="_blank">
                @if(str_contains($media->mime_type, 'image'))
                <img src="{{ url($media->getUrl()) }}" style="height: 100px; border-radius: 5px;">
                @elseif(str_contains($media->mime_type, 'video'))
                <video src="{{ url($media->getUrl()) }}" style="height: 100px; border-radius: 5px;" controls></video>
                @else
                <span>{{ $media->file_name }}</span>
                @endif
            </a>
            <button type="button" class="btn-remove-media" data-id="{{ $media->id }}" style="position: absolute; top: -8px; right: -8px; background: red; color: white; border: none; border-radius: 50%; cursor: pointer; width: 20px; height: 20px; line-height: 18px; font-size: 12px;">x</button>
        </div>
        @endforeach
    </div>
    @endif

    {{-- Preview Container --}}
    <div id="{{ $id }}_preview" class="mt-3 d-flex flex-wrap" style="gap: 10px;"></div>

    <script>
        (function() {
            const input = document.getElementById('{{ $id }}');
            const preview = document.getElementById('{{ $id }}_preview');
            const dt = new DataTransfer();

            // Handle Existing Media Deletion
            document.querySelectorAll('.btn-remove-media').forEach(btn => {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();

                    let id = this.getAttribute('data-id');
                    let container = document.getElementById('media-' + id);

                    fetch('{{ route("remove_img") }}?id=' + id)
                        .then(response => {
                            if (response.ok) {
                                container.remove();
                            } else {
                                alert('Error deleting media');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('Error deleting media');
                        });
                });
            });

            input.addEventListener('change', function(e) {
                if (!this.hasAttribute('multiple')) return;

                // Add new files to DataTransfer
                for (let i = 0; i < this.files.length; i++) {
                    let file = this.files[i];
                    // Prevent duplicates based on name and size
                    let exists = false;
                    for (let j = 0; j < dt.files.length; j++) {
                        if (dt.files[j].name === file.name && dt.files[j].size === file.size) {
                            exists = true;
                            break;
                        }
                    }
                    if (!exists) {
                        dt.items.add(file);
                    }
                }

                // Update input files
                this.files = dt.files;

                // Update Preview
                renderPreview();
            });

            function renderPreview() {
                preview.innerHTML = '';
                for (let i = 0; i < dt.files.length; i++) {
                    let file = dt.files[i];
                    let reader = new FileReader();

                    let div = document.createElement('div');
                    div.style.position = 'relative';
                    div.style.display = 'inline-block';
                    div.style.border = '1px solid #ddd';
                    div.style.padding = '5px';
                    div.style.borderRadius = '5px';

                    // Check if image or video
                    if (file.type.startsWith('image/')) {
                        let img = document.createElement('img');
                        img.style.height = '100px';
                        img.style.borderRadius = '5px';
                        div.appendChild(img);

                        reader.onload = (function(aImg) {
                            return function(e) {
                                aImg.src = e.target.result;
                            };
                        })(img);
                        reader.readAsDataURL(file);
                    } else if (file.type.startsWith('video/')) {
                        let video = document.createElement('video');
                        video.style.height = '100px';
                        video.style.borderRadius = '5px';
                        video.controls = true;

                        let source = document.createElement('source');
                        source.src = URL.createObjectURL(file);
                        video.appendChild(source);
                        div.appendChild(video);
                    } else {
                        let span = document.createElement('span');
                        span.innerText = file.name;
                        div.appendChild(span);
                    }

                    // Remove Button
                    let btn = document.createElement('button');
                    btn.innerText = 'x';
                    btn.style.position = 'absolute';
                    btn.style.top = '-8px';
                    btn.style.right = '-8px';
                    btn.style.background = 'red';
                    btn.style.color = 'white';
                    btn.style.border = 'none';
                    btn.style.borderRadius = '50%';
                    btn.style.cursor = 'pointer';
                    btn.style.width = '20px';
                    btn.style.height = '20px';
                    btn.style.lineHeight = '18px';
                    btn.style.fontSize = '12px';

                    btn.onclick = function(e) {
                        e.preventDefault();
                        dt.items.remove(i);
                        input.files = dt.files;
                        renderPreview();
                    };

                    div.appendChild(btn);
                    preview.appendChild(div);
                }
            }
        })();
    </script>
</div>