<?php

namespace Modules\Categories\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Playground\Models\Playground;

use App\Traits\Translatable;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use App\Traits\DefaultMediaImage;

class Category extends Model implements HasMedia
{
    use Translatable, \App\Traits\HasUnifiedMedia, DefaultMediaImage, \App\Traits\HelperModelTrait;

    protected $translatable = ['name' , 'description'];

    protected $fillable = [
        'name',
        'name_ar',
        'status',
        "description",
        "description_ar",
        'media',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    public function playgrounds()
    {
        return $this->hasMany(Playground::class, 'Category_ID');
    }

    public function getStatusTextAttribute()
    {
        return $this->status ? __('active') : __('inactive');
    }
}
