<?php

use Illuminate\Support\Facades\Route;
use Modules\User\Controllers\{
    ProfileController,
    WebController,
};

include __DIR__ . '/auth.php';

Route::group(['middleware' => 'auth'], function () {
    Route::resource('users', ProfileController::class)->only('index', 'update', 'edit', 'show');
    Route::get('myorders', [ProfileController::class,'myorders'])->name('users.orders');
    Route::get('favourites', [ProfileController::class,'favourites'])->name('users.favourites');
    Route::get('subscribe', [ProfileController::class,'subscribe'])->name('users.subscribe');
    Route::delete('delete_account', [ProfileController::class,'delete_account'])->name('delete_account');
    Route::any('password_change', [ProfileController::class,'password_change'])->name('password.change');
});

Route::match(['get', 'post'], 'login', [WebController::class,'login'])->name('login');
Route::get('newsletter', [ProfileController::class,'newsletter'])->name('newsletter');
