<?php

use Illuminate\Support\Facades\Route;
use Modules\User\Controllers\Admin\{
    AdminController,
    AdminSupervisorController,
    RolesController,
    ModeratorsController,
};

Route::group(['namespace' => 'Admin'], function () {
    Route::get('all/notifications', [AdminController::class, 'notifications'])->name('notifications.page');
    Route::post('notifications/mark/read', [AdminController::class, 'markNotifyRead'])->name('notifications.read');
    Route::resource('users', AdminController::class);
    Route::resource('supervisors', AdminSupervisorController::class);
    Route::post('saveToken', [AdminController::class, 'saveToken'])->name('saveToken');

    Route::get('user_active_supervisor', [AdminController::class, 'active_supervisor'])->name('users.active_supervisor');
    Route::get('user_active_status', [AdminController::class, 'active_status'])->name('users.active_status');
    Route::resource('roles', RolesController::class);
    Route::resource('moderators', ModeratorsController::class);
    Route::get('moderators_active_status', [ModeratorsController::class, 'active_status'])->name('moderators.active_status');
    Route::get('users/search', [AdminController::class, 'userSearch'])->name('users.search');
});
