<?php 


namespace Modules\Reviews\Services;

use Modules\Reviews\Models\Review;

class ApiService
{
protected $coloums = ['user_id' , 'playground_id' , 'rate' , 'comment' , 'reviewable_id' , 'created_at' , 'updated_at',]; 


public function index(){

$sort_by = request('sort_by', null);
$order = request('sort_order') ?: 'desc';
$user_id = request('user_id', null);
$playground_id = request('playground_id', null);
$rating = request('rating', null);
$comment = request('comment', null);
$reviewable_id = request('reviewable_id', null);
$reviewable_type = request('reviewable_type', null);
$created_at = request('created_at', null);
$updated_at = request('updated_at', null);

    $query =   Review::query()->when($user_id, function ($q, $user_id) {
                $q->where('user_id', 'LIKE', "%$user_id%");
            })->when($playground_id, function ($q, $playground_id) {
                $q->where('playground_id', 'LIKE', "%$playground_id%");
            })
            ->when($rating, function ($q, $rating) {
                $q->where('rating', 'LIKE', "%$rating%");   
            })
            ->when($comment, function ($q, $comment) {
                $q->where('comment', 'LIKE', "%$comment%");
            })
            ->when($reviewable_id, function ($q, $reviewable_id) {
                $q->where('reviewable_id', 'LIKE', "%$reviewable_id%");
            })
          
            ->when($user_id, function ($q, $user_id) {
                $q->where('user_id', 'LIKE', "%$user_id%");
            })
            ->when($reviewable_type, function ($q, $reviewable_type) {
                $q->where('reviewable_type', 'LIKE', "%$reviewable_type%");
            })
            ->when($created_at, function ($q, $created_at) {
                $q->where('created_at', 'LIKE', "%$created_at%");
            })
            ->when($updated_at, function ($q, $updated_at) {    
                $q->where('updated_at', 'LIKE', "%$updated_at%");
            });
        if ($sort_by && array_key_exists($sort_by, $this->coloums)) {
            $query->orderBy($this->coloums[$sort_by], $order);
        }

        return $query->paginate(request('limit', 15));
}

public function store($data){

    $review = Review::create($data);

    return $review;
}


public function update($data, $id){

    $review = Review::find($id);

    if(!$review){

        return false;
    }

    $review->update($data);

    return $review;
}

public function destroy($id){

    $review = Review::find($id);

    if(!$review){

        return false;
    }

    $review->delete();

    return $review;
}










}
