<?php

namespace Modules\Playground\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\User\Resources\UserResource;

class PlaygroundListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  $this->id,
            'name'    =>  (string) $this->Name,
            'organizer' => UserResource::make($this->whenLoaded('user')),
            'image' => $this->image,
        ];
    }
}
