<?php

namespace Modules\Match\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreMatchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'playground_id' => 'required',
            'name' => 'required|string',
            'date' => 'required|date|after_or_equal:today',
            'price' => 'required',
            'status' => 'nullable|in:completed,cancelled',
            'About' => 'nullable|string',
            'gender' => 'nullable|in:male,female,co_ed',
            'players_per_side' => 'required',
            'currency' => 'nullable',
            'start_time' => 'required',
            'end_time' => 'required',
            'paid_online' => 'nullable|boolean',
            'refund' => 'nullable|boolean',
        ];
    }
}
