<?php

namespace Modules\Categories\Services;

use App\Services\Services;
use Modules\Categories\Models\Category;

class CategoryService extends Services
{

       private $columns = [
        'id' => 'id',
        'name' => 'name'
    ];


    public function     getAll()
    {

        $column = request('sort_by', null);
        $order = request('sort_order') ?: 'desc';
        $name = request('name', null);
        $query = Category::query()
            ->when($name, function ($q, $name) {
                $q->where('name', 'LIKE', "%$name%");
            });
            
        if ($column && array_key_exists($column, $this->columns)) {
            $query->orderBy($this->columns[$column], $order);
        }

        return $query->paginate(request('limit', 15));

    }

    public function create(array $data)
    {
        return Category::create($data);
    }


    
    public function findById($id)
    {
        $category = Category::find($id);
        if (!$category) {
            $this->setError(__('messages.Category not found')); 
            return false;
        }
        return $category;
    }

    public function update($id, array $data)
    {
        $category = Category::find($id);
        if (!$category) {
            $this->setError(__('messages.Category not found')); 
            return false;
        }
        $category->update($data);
        return $category;
    }

    public function delete($id)
    {
        $category = Category::find($id);
        if (!$category) {
            $this->setError(__('messages.Category not found')); 
            return false;
        }

        return $category->delete();
    }
}
