<?php

namespace App\Traits;

use Illuminate\Support\Facades\Log;

trait Translatable
{
   

    public function getAttribute($key)
    {
    
        if (property_exists($this, 'translatable') && in_array($key, $this->translatable)) {
            $lang = request()->header('lang') ?? app()->getLocale();

        Log::info("Key: $key, Lang: $lang, Header: " . request()->header('lang') . ", AppLocale: " . app()->getLocale());


          
            if ($lang == 'ar') {
                $arKey = $key . '_ar';
                if (array_key_exists($arKey, $this->attributes) && !empty($this->attributes[$arKey])) {
                    return $this->attributes[$arKey];
                }
            }
        }

        return parent::getAttribute($key);
    }

    public function toArray()
    {
        $attributes = parent::toArray();
        if (property_exists($this, 'translatable')) {
            foreach ($this->translatable as $field) {
                unset($attributes[$field . '_ar']);
            }
        }
        return $attributes;
    }
}
