<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\DatabaseNotification;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;
use Modules\User\Enums\UserTypeEnum;
use Modules\User\Models\User;

class AdminTopicNotifications extends Notification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    protected $data;
    public function __construct( protected  $type = '',protected  $title = '', protected  $message = '')
    {
        $this->data['title'] = @$title;
        $this->data['message'] = @$message;

        $this->data['type'] = 'admin_notification';
        DatabaseNotification::create([
            'id' => Str::uuid(),
            'type' => self::class,
            'notifiable_type' => User::class,
            'notifiable_id' => 0,
            'read_at' => now(),
            'data' => $this->data,
        ]);
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [  FcmChannel::class ];
    }



    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */

    public function toFcm($notifiable)
    {
        app(FCMAction::class)->withData($this->data)
        ->withTitle($this->title)
        ->withBody($this->message)
        ->withTopic($this->type)
        ->sendMessage('topic');
    }
}
