<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UploadMediaJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    protected $model;
    protected $filePath;
    protected $collection;
    protected $disk;

    /**
     * Create a new job instance.
     */
    public function __construct($model, $filePath, $collection = 'default', $disk = 'public')
    {
        $this->model = $model;
        $this->filePath = $filePath;
        $this->collection = $collection;
        $this->disk = $disk;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if (file_exists($this->filePath)) {
            $this->model->addMedia($this->filePath)
                ->preservingOriginal() // Optional: keep temp file? No, better delete.
                ->toMediaCollection($this->collection, $this->disk);

            // Delete temp file after upload
            @unlink($this->filePath);
        }
    }
}
