<?php

namespace App\Http\Requests\Admin\Playgrounds;

use Illuminate\Foundation\Http\FormRequest;

class Store extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'Name' => 'required|string|max:250',
            'Category_ID' => 'required|exists:categories,id',
            'Owner' => 'nullable|string|max:250',
            'City' => 'nullable|string|max:250',
            'Telephone' => 'nullable|string|max:20',
            'Email' => 'nullable|email|max:250',
            'Grass_Type' => 'nullable|string|max:250',
            'Accessibility' => 'nullable|string|max:250',
            'Address' => 'required|string',
            'Latitude' => 'required|numeric|min:-90|max:90',
            'Longitude' => 'required|numeric|min:-180|max:180',
            'media' => 'nullable|array',
            'media.*' => 'file|mimes:jpeg,png,jpg,gif,svg,mp4,mov,avi,wmv|max:20480',
            'slots' => 'nullable|array',
            'organizer_user_id' => 'nullable|exists:users,id',
            'Disability_Parking' => 'nullable|boolean',
            'Disability_Activity_Areas' => 'nullable|boolean',
            'Disability_Social_Areas' => 'nullable|boolean',
            'Disability_Spectator_Areas' => 'nullable|boolean',
            'Disability_Changing_Facilities' => 'nullable|boolean',
            'Disability_Toilets' => 'nullable|boolean',
            'Disability_Finding_and_Reaching_the_Entrance' => 'nullable|boolean',
            'Disability_Reception_Area' => 'nullable|boolean',
            'Disability_Doorways' => 'nullable|boolean',
            'Disability_Emergency_Exits' => 'nullable|boolean',
            'status' => 'nullable|in:active,inactive,pending',
        ];
    }
}
