<?php

namespace App\Http\Middleware\Api;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetCategoryContext
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $categoryId = $request->header('category_id') ?? $request->header('Category-ID');

        if ($categoryId) {
            config(['context.category_id' => $categoryId]);
        }

        return $next($request);
    }



}
