<?php

namespace App\Http\Middleware\Api;

use App\Helpers\ApiResponse;
use Carbon\Carbon;
use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Laravel\Sanctum\PersonalAccessToken;

class AuthCheck
{
    public function handle($request, Closure $next)
    {
        if($request->bearerToken()){
            $token = PersonalAccessToken::findToken($request->bearerToken());
            if(!$token){
                return ApiResponse::failed(__('token is invalid'));
            }
            $user = $token->tokenable;
            if ($user->banned) {
                return ApiResponse::failed(__('Your account is blocked'));
            }
            if ($user->banned_from <= Carbon::now() && $user->banned_to >= Carbon::now()) {
                return ApiResponse::failed(__('Your account is blocked'));
            }
        }
        return $next($request);
    }
}
