<?php

namespace Modules\User\Services;

use App\Helpers\ApiResponse;
use App\Services\Services;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Modules\User\Emails\OtpMail;
use Modules\User\Models\Device;
use Modules\User\Models\Otp;
use Modules\User\Models\User;
use Modules\User\Requests\LoginRequest;
use Modules\User\Requests\ValidationPageRequst;
use Illuminate\Support\Facades\Validator;
use Modules\User\Resources\UserResource;
use Modules\Playground\Models\Playground;

class AuthService extends Services
{
    public function registerplaygroundmaster(array $data)
    {

        DB::beginTransaction();
        $data['role_id'] = 1;
        $image = $data['image'] ?? null;
        unset($data['image']);

        // $data['status'] = false; 

        $user = User::create($data);

        if ($image) {
            $user->image = $image;
        }

        // Create Pending Playground
        Playground::create([
            'Name' => $data['playground_name'],
            'Address' => $data['playground_address'],
            'Latitude' => $data['playground_latitude'],
            'Longitude' => $data['playground_longitude'],
            'Owner_ID' => $user->id,
            'Owner' => $user->FirstName . ' ' . $user->LastName,
            'status' => 'pending',
            'City' => '', // Default or extract if available
            'Telephone' => $user->phone, // Use user phone as default
            'Email' => $user->email, // Use user email as default
            'Category_ID' => $data['Category_ID'] ?? config('context.category_id'),
        ]);

        // $this->sendOtp($user);   This For Sending Otp For Emails 

        DB::commit();
        return [
            'user' => $user,
            'message' => __('messages.Please check your email for verification code')
        ];
    }


    public function registerplayer(array $data)
    {
        $data['role_id'] = 2;
        $image = $data['image'] ?? null;

        unset($data['image']);
        // $data['status'] = false; 
        $user = User::create($data);

        if ($image) {
            $user->image = $image;
        }

        // $this->sendOtp($user);

        return [
            'user' => $user,
            'message' => __('messages.Please check your email for verification code')
        ];
    }

    public function login($credentials)
    {

        $user = User::with('role')->where('email', $credentials['email'])->first();
        if (!$user || !Hash::check($credentials['password'], $user->password)) {
            return false;
        }
        // if (!$user->status) {
        //     return 'not_active';   
        // }


        $token = $user->createToken('authToken')->plainTextToken;

        if (isset($credentials['device_token']) && isset($credentials['platform']) && isset($credentials['uuid'])) {
            Device::updateOrCreate(
                ['uuid' => $credentials['uuid']],
                [
                    'user_id' => $user->id,
                    'user_type' => get_class($user),
                    'token' => $credentials['device_token'],
                    'platform' => $credentials['platform']
                ]
            );
        }

        return [
            'user' => new UserResource($user),
            'token' => $token
        ];
    }

    public function logout($user)
    {
        $user->currentAccessToken()->delete();
        return true;
    }



    public function verifyOtp($email, $otp)
    {
        $user = User::where('email', $email)->first();
        if (!$user) {
            return false;
        }

        $otpRecord = Otp::where('user_id', $user->id)
            ->where('otp', $otp)
            ->where('expired_at', '>', now())
            ->first();

        if (!$otpRecord) {
            return false;
        }

        $user->update(['status' => true]);
        $otpRecord->delete();

        $token = $user->createToken('authToken')->plainTextToken;

        return [
            'user' => $user,
            'token' => $token
        ];
    }



    public function resendOtp($email)
    {
        $user = User::where('email', $email)->first();
        if (!$user) {
            return false;
        }

        $this->sendOtp($user);
        return true;
    }



    private function sendOtp($user)
    {
        $otp = rand(100000, 999999);
        Otp::create([
            'user_id' => $user->id,
            'otp' => $otp,
            'expired_at' => now()->addMinutes(15)
        ]);
        Mail::to($user->email)->send(new OtpMail($otp));
    }

    public function ValidateRequest(array $data)
    {
        $rules = (new ValidationPageRequst())->rules();
        $rules = array_intersect_key($rules, $data);

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            return $validator->errors();
        }

        return true;
    }
}
