<?php

namespace Modules\Reviews\Controllers;

use App\Helpers\ApiResponse;
use Modules\Reviews\Requests\StoreReviewRequest;
use Modules\Reviews\Requests\UpdateReviewRequest;
use Modules\Reviews\Resources\ReviewCollection;
use Modules\Reviews\Resources\ReviewResource;
use Modules\Reviews\Services\ApiService;
use App\Http\Controllers\Controller;

class ApiController extends Controller
{
    protected $apiService;

    public function __construct(ApiService $apiService)
    {

        $this->apiService = $apiService;
    }

    public function index()
    {

        $reviews = $this->apiService->index();
        $reviews->load('user', 'reviewable');

        if (!$reviews) {

            return ApiResponse::failed(__('messages.Reviews not found'), 404);
        }

        return ApiResponse::loaded(new ReviewCollection($reviews), 200, 'success');
    }

    public function store(StoreReviewRequest $request)
    {

        $review = $this->apiService->store($request->validated());

        if (!$review) {

            return ApiResponse::failed(__('messages.Review not created'), 400);
        }

        return ApiResponse::loaded(new ReviewResource($review), 200, 'success');
    }

    public function update(UpdateReviewRequest $request , $id)
    {

        $review = $this->apiService->update($request->validated(), $id);

        if (!$review) {

            return ApiResponse::failed(__('messages.Review not updated'), 400);
        }

        return ApiResponse::loaded(new ReviewResource($review), 200, 'success');
    }

    public function destroy($id)
    {

        $review = $this->apiService->destroy($id);

        if (!$review) {

            return ApiResponse::failed(__('messages.Review not deleted'), 400);
        }

        return ApiResponse::loaded(new ReviewResource($review), 200, 'success');
    }
}
