<?php

namespace Modules\Playground\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Categories\Resources\CategoryResource;
use Modules\Reviews\Resources\ReviewResource;
use Modules\User\Resources\UserResource;

class PlaygroundResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'site_id' => $this->Site_ID,
            'name' => $this->Name,
            'owner' => $this->Owner,
            'owner_id' => $this->Owner_ID,
            'address' => $this->Address,
            'city' => $this->City,
            'telephone' => $this->Telephone,
            'email' => $this->Email,
            'grass_type' => $this->Grass_Type,
            'accessibility' => $this->translateFunctionAccessibility($this->Accessibility),
            'status' => $this->status,
            'disability_parking' => (bool) $this->Disability_Parking,
            'disability_activity_areas' => (bool) $this->Disability_Activity_Areas,
            'disability_social_areas' => (bool) $this->Disability_Social_Areas,
            'disability_spectator_areas' => (bool) $this->Disability_Spectator_Areas,
            'disability_changing_facilities' => (bool) $this->Disability_Changing_Facilities,
            'disability_toilets' => (bool) $this->Disability_Toilets,
            'disability_finding_and_reaching_the_entrance' => (bool) $this->Disability_Finding_and_Reaching_the_Entrance,
            'disability_reception_area' => (bool) $this->Disability_Reception_Area,
            'disability_doorways' => (bool) $this->Disability_Doorways,
            'disability_emergency_exits' => (bool) $this->Disability_Emergency_Exits,
            'latitude' => $this->Latitude,
            'longitude' => $this->Longitude,
            'distance' => $this->distance,
            'category' => CategoryResource::make($this->whenLoaded('category')),
            'user' => UserResource::make($this->whenLoaded('user')),
            'reviews' => ReviewResource::collection($this->whenLoaded('reviews')),
            'media' => $this->media_list,
           'slots' => $this->slots ?? ['3', '5', '7', '9', '11'],
        ];
    }



    private function translateFunctionAccessibility($value)
    {
        if ($value == 'Public access') {
            return 1;
        } else {
            return  0;
        }
    }
}
