<?php

namespace Modules\Playground\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Categories\Models\Category;
use Modules\Categories\Resources\CategoryResource;

class UpdatePlaygroundRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [

            'name' => 'sometimes|string|max:255|unique:playgrounds,name,' . $this->route('id'),
            'owner' => 'sometimes|string|max:255',
            'Category_ID' => 'sometimes|exists:categories,id',
            'address' => 'sometimes|string|max:255',
            'city' => 'sometimes|string|max:255',
            'telephone' => 'sometimes|string|max:255',
            'email' => 'sometimes|email|max:255',
            'grass_type' => 'sometimes|string|max:255',
            'accessibility' => 'sometimes|string|max:255',
            'status' => 'sometimes|in:active,inactive,pending',
            'disability_parking' => 'sometimes|boolean',
            'disability_activity_areas' => 'sometimes|boolean',
            'disability_social_areas' => 'sometimes|boolean',
            'disability_spectator_areas' => 'sometimes|boolean',
            'disability_changing_facilities' => 'sometimes|boolean',
            'disability_toilets' => 'sometimes|boolean',
            'disability_finding_and_reaching_the_entrance' => 'sometimes|boolean',
            'disability_reception_area' => 'sometimes|boolean',
            'disability_doorways' => 'sometimes|boolean',
            'disability_emergency_exits' => 'sometimes|boolean',
            'latitude' => 'sometimes|numeric|min:-90|max:90',
            'longitude' => 'sometimes|numeric|min:-180|max:180',
            'media' => 'sometimes|array',
            'media.*' => 'file|mimes:jpeg,png,jpg,gif,svg,mp4,mov,avi,wmv|max:20480',
            'slots' => 'sometimes|array',
        ];
    }
}
